/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.WeakPower;

public class Tranquilizer
extends AbstractCard {
    public static final String ID = "Tranquilizer";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Tranquilizer");
    public static final String NAME = "Tranquilizer";
    public static final String DESCRIPTION = "Deal !D! damage. NL Apply !M! Weak.";
    private static final int COST = 0;
    private static final int DAMAGE_AMT = 1;
    private static final int WEAK_AMT = 1;
    private static final int POOL = 1;

    public Tranquilizer() {
        super("Tranquilizer", "Tranquilizer", null, 0, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.subType = AbstractCard.CardSubType.AMMO;
        this.baseDamage = 1;
        this.magicNumber = this.baseMagicNumber = 1;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.FIRE));
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, p, new WeakPower(m, this.magicNumber, false), this.magicNumber));
    }

    @Override
    public void fire(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m);
    }

    @Override
    public AbstractCard makeCopy() {
        return new Tranquilizer();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(1);
        }
    }
}

